<?php
/*
	$Id: xajax.checkout.php 2 2011-02-17 13:35:25Z akausch $
*/

function checkout_check() {
	$objResponse = new xajaxResponse();
	if (empty($_SESSION['customer_id']))
		$objResponse->script("window.location.href = '".FILENAME_LOGIN."';");
	else {
		global $order;
		global $checkout;
		global $xtPrice;

		$order = new order();
		require (DIR_WS_CLASSES.'shipping.php');
		$shipping_modules = new shipping;
		$chkt_error_shipping = '';
		$chkt_error_payment = '';
		if (empty($_SESSION['shipping']) && $checkout->isVirtual() != 1 && $checkout->isFreeShipping($order, $xtPrice) == false && (xtc_not_null(MODULE_SHIPPING_INSTALLED)))
			$chkt_error_shipping .= '- '.CHECKOUT_NO_SHIPPING_MODULE_SELECTED;

		if (empty($_SESSION['payment']) && (xtc_not_null(MODULE_PAYMENT_INSTALLED)))
			$chkt_error_payment .= '- '.CHECKOUT_NO_PAYMENT_MODULE_SELECTED;

		if (!empty($chkt_error_shipping)) $objResponse->assign("checkout_error_shipping","innerHTML",$chkt_error_shipping);
		if (!empty($chkt_error_payment)) $objResponse->assign("checkout_error_payment","innerHTML",$chkt_error_payment);

		if (empty($chkt_error_shipping) && empty($chkt_error_payment))
			$objResponse->script("document.getElementById('checkout').submit();");
		else {
			if (!empty($chkt_error_shipping)) $objResponse->script("document.getElementById('checkout_error_shipping').style.display = '';");
			if (!empty($chkt_error_payment)) $objResponse->script("document.getElementById('checkout_error_payment').style.display = '';");
		}
		$objResponse->script("document.getElementById('checkout_please_wait').style.display = 'none';
							  document.getElementById('checkout_please_wait').innerHTML = '';");
	}
	return $objResponse;
}

function useGV($yn) {
	$objResponse = new xajaxResponse();
	if (empty($_SESSION['customer_id'])) {
		$objResponse->script("window.location.href = '".FILENAME_LOGIN."';");
	} else {
		global $xtPrice;
		global $order;
		global $checkout;
		global $order_total_modules;

		if ($yn == 1) {
			$_SESSION['cot_gv'] = true;
			if (!empty($_SESSION['payment']) && $_SESSION['payment'] != 'no_payment') $_SESSION['old_payment'] = $_SESSION['payment'];
		} else {
			if (!empty($_SESSION['old_payment'])) {
				$_SESSION['payment'] = $_SESSION['old_payment'];
				unset($_SESSION['old_payment']);
				$_SESSION['cot_gv'] = false;
			}
		}
		$order = new order();
		$order_total_modules = new order_total;
		$order_total_modules->process();
		if ($order->info['total'] <= 0) {
			if (!empty($_SESSION['old_payment'])) unset($_SESSION['payment']);
		}
		$order = new order;
		$order_total_modules = new order_total;
		$order_total_modules->process();
		if ($order->info['total'] <= 0) {
			if (!empty($_SESSION['old_payment'])) $_SESSION['payment'] = $_SESSION['old_payment'];
		}
		if ($order->info['total'] <= 0) {
			$_SESSION['payment'] = 'no_payment';
		}
		$virtual = $checkout->isVirtual();
		$payment_modules = new payment();
		$payment_modules->update_status();

		$payment_button = '';
		$payment_button .= utf8_encode(str_replace("\n","",$payment_modules->process_button(true)));

		if ($order->info['total'] <= 0) {
			$form_url = $checkout->getFormUrl();
			$objResponse->script("document.getElementById('payment_modules').style.display = 'none';
								  document.getElementById('payment_gccover').style.display = '';
								  document.getElementById('loader_payment_modules').style.display = 'none';
								  document.getElementById('checkout').action = '$form_url';
								  document.getElementById('checkout_hiddens').innerHTML = '$payment_button';
								  document.getElementById('checkout_error_payment').style.display = 'none';
								  document.getElementById('checkout_error_payment').innerHTML = '';
								  if (document.getElementById('btn_payment_modules').innerHTML == '-') { showFromStart('payment_modules') }");

		} else {
			$form_url = $checkout->getFormUrl();
			$objResponse->script("document.getElementById('payment_modules').style.display = '';
								  document.getElementById('payment_gccover').style.display = 'none';
								  document.getElementById('loader_payment_modules').style.display = 'none';
								  document.getElementById('checkout').action = '$form_url';
								  document.getElementById('checkout_hiddens').innerHTML = '$payment_button';
								  if (document.getElementById('btn_payment_modules').innerHTML == '-') { showFromStart('payment_modules') }");
		}
		if ($virtual == 1) {
			$objResponse->script("updateBecauseItsVirtual();");
		} else {
			if ($checkout->isFreeShipping($order, $xtPrice)) {
				$objResponse->script("updateBecauseItsFreeShipping();");
			}  else {
				$objResponse->script("updateBecauseItsNotFreeShipping();");
			}
		}
		$objResponse->assign("checkout_total","innerHTML",$checkout->getTotalBlock($order, $order_total_modules, $xtPrice));
	}
	return $objResponse;
}

function updatePaymentModule($vars) {
	$objResponse = new xajaxResponse();
	if (empty($_SESSION['customer_id']))
		$objResponse->script("window.location.href = '".FILENAME_LOGIN."';");
	else {
		global $checkout;
		global $order;
		global $xtPrice;
		global $order_total_modules;

		$_SESSION['checkout_payment_error'] = '';
		$vars = $checkout->convertToVars($vars);
		$_SESSION['payment'] = xtc_db_prepare_input($vars['payment']);
		//total10 LS-Quickfix
		$_SESSION['t10lsqf'] = xtc_db_prepare_input($vars);
		//total10 LS-Quickfix Ende
		if (isset ($_SESSION['credit_covers']))
			$_SESSION['payment'] = 'no_payment';

		$order = new order();
		$order_total_modules = new order_total();
		$order_total_modules->process();
		$payment_modules = new payment($_SESSION['payment']);
		$payment_modules->update_status();
		$payment_modules->pre_confirmation_check($vars);
		$payment_button = '';
		$payment_button .= utf8_encode(str_replace("\n","",$payment_modules->process_button(false, $vars)));

		$form_url = $checkout->getFormUrl();
		if ($_SESSION['checkout_payment_error'] != '') {
			unset($_SESSION['payment']);
			$perror = $checkout->convertToVars($_SESSION['checkout_payment_error']);
			$objResponse->script("document.getElementById('payment_module_error').innerHTML = '".utf8_encode($perror['error'])."'");
			$objResponse->script("activatePayment('no');");
		} else {
			if ($_SESSION['payment'] == 'luupws') {
				$objResponse->assign("pmodule_luupws","innerHTML","");
				$objResponse->script("document.getElementById('pmodule_luupws').style.display = 'none';
									  document.getElementById('pmodule_luupws2').style.display = '';");
			}
			if ($_SESSION['stat_luupws'] == 1 || $_SESSION['payment'] != 'luupws') $objResponse->script("activatePayment('prow_".$_SESSION['payment']."');");
			if ($_SESSION['stat_luupws'] != 1 && $_SESSION['payment'] == 'luupws') $objResponse->script("activatePayment('no');");
			if ($_SESSION['stat_luupws'] == 1 || $_SESSION['payment'] != 'luupws') $objResponse->script("document.getElementById('payment_module_error').innerHTML = '<span class=\"module_ok\">".utf8_encode(CHECKOUT_PAYMENT_OK)."</span>';
							  document.getElementById('shipping_module_error').innerHTML = '&nbsp;';
							  document.getElementById('checkout_hiddens').innerHTML = '$payment_button';
							  clearBlinkBlink('payment');");

			if ($_SESSION['payment'] == 'luupws') $_SESSION['stat_luupws'] = 1;
		}
		if ($order->info['total'] <= 0) {
			if (!empty($_SESSION['payment']) && $_SESSION['payment'] != 'no_payment') {
					$_SESSION['old_payment'] = $_SESSION['payment'];
					$_SESSION['payment'] = 'no_payment';
			}
			$order = new order;
			$order_total_modules = new order_total;
			$order_total_modules->process();
			$form_url = $checkout->getFormUrl();
			$objResponse->script("document.getElementById('payment_modules').style.display = 'none';
								  document.getElementById('payment_gccover').style.display = '';");
		}
		$objResponse->script("document.getElementById('loader_payment_modules').style.display = 'none';
							  makeActive(document.getElementById('form_payment_modules'));
							  showFromStart('payment_modules');
							  document.getElementById('checkout').action = '$form_url';
							  if (document.getElementById('btn_shipping_modules').innerHTML == '-') showFromStart('shipping_modules');");

		$objResponse->assign("checkout_total","innerHTML",$checkout->getTotalBlock($order, $order_total_modules, $xtPrice));
	}
	return $objResponse;
}

function updateShippingModule($vars) {
	$objResponse = new xajaxResponse();
	if (empty($_SESSION['customer_id']))
		$objResponse->script("window.location.href = '".FILENAME_LOGIN."';");
	else {
		global $checkout;
		global $order;
		global $xtPrice;
		global $total_weight;
		global $total_count;
		global $order_total_modules;

		$total_weight = $_SESSION['cart']->show_weight();
		$total_count = $_SESSION['cart']->count_contents();

		require (DIR_WS_CLASSES.'shipping.php');
		$shipping_modules = new shipping;
		$vars = $checkout->convertToVars($vars);
		$_SESSION['shipping'] = xtc_db_prepare_input($vars['shipping']);
		list ($module, $method) = explode('_', $_SESSION['shipping']);
		global $$module;
		if (is_object($$module) || ($_SESSION['shipping'] == 'free_free')) {
			if ($_SESSION['shipping'] == 'free_free') {
				$quote[0]['methods'][0]['title'] = FREE_SHIPPING_TITLE;
				$quote[0]['methods'][0]['cost'] = '0';
			} else
				$quote = $shipping_modules->quote($method, $module);

			if (isset ($quote['error']))
				unset ($_SESSION['shipping']);
			else {
				if ((isset ($quote[0]['methods'][0]['title'])) && (isset ($quote[0]['methods'][0]['cost'])))
					$_SESSION['shipping'] = array ('id' => $_SESSION['shipping'], 'title' => (($checkout->isFreeShipping($order, $xtPrice) == true) ? $quote[0]['methods'][0]['title'] : $quote[0]['module'].' ('.$quote[0]['methods'][0]['title'].')'), 'cost' => $quote[0]['methods'][0]['cost']);
			}
		} else
			unset ($_SESSION['shipping']);

		$order = new order;
		$order_total_modules = new order_total;
		$order_total_modules->process();
		$payment_modules = new payment();
		$payment_modules->update_status();

		$payment_button = '';
		$payment_button .= utf8_encode(str_replace("\n","",$payment_modules->process_button(true)));

		global $payment_compatible;
		$payment_compatible = true;
		$payment_block = $checkout->getPaymentBlock($xtPrice, $payment_modules);

		$form_url = $checkout->getFormUrl();

		$objResponse->script("activateShipping('srow".($vars[$vars['shipping'].'_num']-1)."');");
		$objResponse->script("document.getElementById('shipping_module_error').innerHTML = '<span class=\"module_ok\">".CHECKOUT_SHIPPING_OK."</span>';
							  document.getElementById('payment_module_error').innerHTML = '&nbsp;';");
		if (!$payment_compatible) $objResponse->script("document.getElementById('payment_module_error').innerHTML = '".CHECKOUT_PAYMENT_NOT_COMPATIBLE."'");
		if ($order->info['total'] <= 0) {
			if (!empty($_SESSION['payment']) && $_SESSION['payment'] != 'no_payment') {
					$_SESSION['old_payment'] = $_SESSION['payment'];
					$_SESSION['payment'] = 'no_payment';
			}
			$order = new order;
			$order_total_modules = new order_total;
			$order_total_modules->process();
			$form_url = $checkout->getFormUrl();
			$objResponse->script("document.getElementById('payment_modules').style.display = 'none';
								  document.getElementById('payment_gccover').style.display = '';");
		}
		$objResponse->assign("payments","innerHTML",$payment_block);
		$objResponse->script("document.getElementById('loader_shipping_modules').style.display = 'none';
							  makeActive(document.getElementById('form_shipping_modules'));
							  document.getElementById('checkout').action = '$form_url';
							  showFromStart('shipping_modules');
							  if (document.getElementById('btn_payment_modules').innerHTML == '-') setTimeout(\"showFromStart('payment_modules')\", 650);
							  document.getElementById('checkout_hiddens').innerHTML = '$payment_button';
							  clearBlinkBlink('shipping');");

		$objResponse->assign("checkout_total","innerHTML",$checkout->getTotalBlock($order, $order_total_modules, $xtPrice));
	}
	return $objResponse;
}

function updateProducts($id, $math) {
	$objResponse = new xajaxResponse();
	if (empty($_SESSION['customer_id']))
		$objResponse->script("window.location.href = '".FILENAME_LOGIN."';");
	else {
		global $xtPrice;
		global $order;
		global $checkout;
		global $total_weight;
		global $total_count;
		global $shipping_modules;
		global $order_total_modules;

		unset($_SESSION['actual_content']);

		$qty_now = (int) $_SESSION['cart']->get_quantity($id);

		if ($math == 'plus') {
			if ($qty_now >= MAX_PRODUCTS_QTY)
				$qty_new = MAX_PRODUCTS_QTY;
			else
				$qty_new = $qty_now + 1;
		} elseif ($math == 'minus') {
			if ($qty_now <= 1)
				$qty_new = $qty_now;
			else
				$qty_new = $qty_now - 1;
		}

		if (STOCK_CHECK == 'true' && STOCK_ALLOW_CHECKOUT != 'true')
			$stock_check = true;

		if (ATTRIBUTE_STOCK_CHECK == 'true' && STOCK_ALLOW_CHECKOUT != 'true')
			$attribute_stock_check = true;

		$count_error_attributes = 0;

		$real_product_id = substr($id, 0, strpos($id, '{'));
		$attributes_string = substr($id, strpos($id, '{'));
		$attributes_sub_arr = explode('{',$attributes_string);
		$options = array();
		$values = array();
		for ($a=0; $a<count($attributes_sub_arr); $a++) {
			if (strlen($attributes_sub_arr[$a]) > 2) {
				$attributes_main_arr = explode('}', $attributes_sub_arr[$a]);
				array_push($options, $attributes_main_arr[0]);
				$attribute_value_query = xtc_db_query("SELECT products_options_value_id FROM ".TABLE_CUSTOMERS_BASKET_ATTRIBUTES." WHERE customers_id = '".$_SESSION['customer_id']."' AND products_id = '".$id."' AND products_options_id = '".$attributes_main_arr[0]."'");
				$attribute_value_arr = xtc_db_fetch_array($attribute_value_query);
				array_push($values, $attribute_value_arr['products_options_value_id']);
			}
		}

		for ($b=0; $b<count($options); $b++) {
			$select_attributes_id_query = xtc_db_query("SELECT products_attributes_id FROM ".TABLE_PRODUCTS_ATTRIBUTES." WHERE products_id = '".$real_product_id."' AND options_id = '".$options[$b]."' AND options_values_id = '".$values[$b]."'");
			$select_attributes_id_arr = xtc_db_fetch_array($select_attributes_id_query);
			if (xtc_check_stock_attributes($select_attributes_id_arr['products_attributes_id'], $qty_new) != '')
				$count_error_attributes++;
		}

		if (($stock_check ? (xtc_check_stock($id, $qty_new) != '') : false) || ($attribute_stock_check ? ($count_error_attributes > 0) : false)) {
			$objResponse->script("document.getElementById('loader_products').style.display = 'none';
								  alert('".html_entity_decode(CHECKOUT_OUT_OF_STOCK)."');
								  ");
		} else {
			$_SESSION['cart']->update_quantity($id, $qty_new, $_SESSION['cart']->contents[$id]['attributes']);
			$order = new order;
			$price_new = 0;
			$tax_class_id = $checkout->getTaxID($id);

			$price_new = $xtPrice->xtcGetPrice($id, $format=false, $qty_new, $tax_class_id, '')+$xtPrice->xtcFormat($_SESSION['cart']->attributes_price($id), false);
			$price_new *= $qty_new;

			$total_weight = $_SESSION['cart']->show_weight();
			$total_count = $_SESSION['cart']->count_contents();

			if (!empty($_SESSION['shipping']['id'])) {
				list ($module, $method) = explode('_', $_SESSION['shipping']['id']);
				if (!is_object($shipping_modules)) {
					require (DIR_WS_CLASSES.'shipping.php');
					$shipping_modules = new shipping;
				}
				$quote = $shipping_modules->quote($method, $module);
				$_SESSION['shipping']['cost'] = $quote[0]['methods'][0]['cost'];
			}
			$order = new order;
			$shipping_block = $checkout->getShippingBlock($xtPrice);
			$order = new order;
			$virtual = $checkout->isVirtual();
			$order_total_modules = new order_total;
			$order_total_modules->process();
			$payment_modules = new payment();
			$payment_modules->update_status();

			$payment_button = '';
			$payment_button .= utf8_encode(str_replace("\n","",$payment_modules->process_button(true)));

			global $payment_compatible;
			$payment_compatible = true;
			$payment_block = $checkout->getPaymentBlock($xtPrice, $payment_modules);

			if ($virtual == 1)
				$objResponse->script("updateBecauseItsVirtual();");
			else {
				if ($checkout->isFreeShipping($order, $xtPrice))
					$objResponse->script("updateBecauseItsFreeShipping();");
				else
					$objResponse->script("updateBecauseItsNotFreeShipping();");
			}

			if ($order->info['total'] <= 0) {
				if (!empty($_SESSION['payment']) && $_SESSION['payment'] != 'no_payment') {
					$_SESSION['old_payment'] = $_SESSION['payment'];
					$_SESSION['payment'] = 'no_payment';
				}
				$order = new order;
				$order_total_modules = new order_total;
				$order_total_modules->process();
				$form_url = $checkout->getFormUrl();

				$objResponse->script("document.getElementById('payment_modules').style.display = 'none';
									  document.getElementById('payment_gccover').style.display = '';
							  		  document.getElementById('checkout').action = '$form_url';
									  if (document.getElementById('btn_payment_modules').innerHTML == '-') { showFromStart('payment_modules') }");

			} else {
				if (!empty($_SESSION['old_payment'])) {
					$_SESSION['payment'] = $_SESSION['old_payment'];
					unset($_SESSION['old_payment']);
					$order = new order;
					$order_total_modules = new order_total;
					$order_total_modules->process();
				}
				$form_url = $checkout->getFormUrl();
				$objResponse->script("document.getElementById('payment_modules').style.display = '';
									  document.getElementById('payment_gccover').style.display = 'none';
							  		  document.getElementById('checkout').action = '$form_url';
									  if (document.getElementById('btn_payment_modules').innerHTML == '-') { showFromStart('payment_modules') }");
			}
			$shippings_count = xtc_count_shipping_modules();

			$objResponse->assign("payments","innerHTML",$payment_block);
			$objResponse->assign("shippings", "innerHTML", $shipping_block);
			$objResponse->assign("qty_$id","innerHTML", $qty_new);
			$objResponse->assign("price_$id","innerHTML", $xtPrice->xtcFormat($price_new, true));
			$objResponse->assign("checkout_products_howmuch","innerHTML", $_SESSION['cart']->count_contents());
			$objResponse->script("document.getElementById('loader_products').style.display = 'none';
								  showFromStart('products');
								  document.getElementById('checkout_hiddens').innerHTML = '$payment_button';
								  document.getElementById('shipping_module_error').innerHTML = '&nbsp;';
								  document.getElementById('payment_module_error').innerHTML = '&nbsp;';
								  if (document.getElementById('btn_shipping_modules').innerHTML == '-') showFromStart('shipping_modules');
								  smodule_length = $shippings_count;
								  ");
			$objResponse->assign("checkout_total","innerHTML",$checkout->getTotalBlock($order, $order_total_modules, $xtPrice));
		}
	}
	return $objResponse;
}

function removeProduct($id) {
	$objResponse = new xajaxResponse();
	if (empty($_SESSION['customer_id'])) {
		$objResponse->script("window.location.href = '".FILENAME_LOGIN."';");
	} else {
		global $checkout;
		global $order;
		global $xtPrice;
		global $total_weight;
		global $total_count;
		global $shipping_modules;
		global $order_total_modules;
		unset($_SESSION['actual_content']);

		$_SESSION['cart']->remove($id);
		$_SESSION['cart']->restore_contents();

		if ($_SESSION['cart']->count_contents() > 0) {

			$order = new order;

			$total_weight = $_SESSION['cart']->show_weight();
			$total_count = $_SESSION['cart']->count_contents();

			if (!empty($_SESSION['shipping']['id'])) {
				list ($module, $method) = explode('_', $_SESSION['shipping']['id']);
				if (!is_object($shipping_modules)) {
					require (DIR_WS_CLASSES.'shipping.php');
					$shipping_modules = new shipping;
				}
				$quote = $shipping_modules->quote($method, $module);
				$_SESSION['shipping']['cost'] = $quote[0]['methods'][0]['cost'];
			}
			$order = new order;
			$shipping_block = $checkout->getShippingBlock($xtPrice);
			$order = new order;
			$virtual = $checkout->isVirtual();
			$order_total_modules = new order_total;
			$order_total_modules->process();
			$payment_modules = new payment();
			$payment_modules->update_status();

			$payment_button = '';
			$payment_button .= utf8_encode(str_replace("\n","",$payment_modules->process_button(true)));

			global $payment_compatible;
			$payment_compatible = true;
			$payment_block = $checkout->getPaymentBlock($xtPrice, $payment_modules);

			if ($order->info['total'] <= 0) {
				if (!empty($_SESSION['payment']) && $_SESSION['payment'] != 'no_payment') {
					$_SESSION['old_payment'] = $_SESSION['payment'];
					$_SESSION['payment'] = 'no_payment';
				}
				$order = new order;
				$order_total_modules = new order_total;
				$order_total_modules->process();
				$form_url = $checkout->getFormUrl();

				$objResponse->script("document.getElementById('payment_modules').style.display = 'none';
									  document.getElementById('payment_gccover').style.display = '';
							  		  document.getElementById('checkout').action = '$form_url';
									  if (document.getElementById('btn_payment_modules').innerHTML == '-') { showFromStart('payment_modules') }");

			} else {
				if (!empty($_SESSION['old_payment'])) {
					$_SESSION['payment'] = $_SESSION['old_payment'];
					unset($_SESSION['old_payment']);
					$order = new order;
					$order_total_modules = new order_total;
					$order_total_modules->process();
				}
				$form_url = $checkout->getFormUrl();
				$objResponse->script("document.getElementById('payment_modules').style.display = '';
									  document.getElementById('payment_gccover').style.display = 'none';
							  		  document.getElementById('checkout').action = '$form_url';
									  if (document.getElementById('btn_payment_modules').innerHTML == '-') { showFromStart('payment_modules') }");
			}

			$shippings_count = xtc_count_shipping_modules();
			$objResponse->assign("shippings", "innerHTML", $shipping_block);
			$objResponse->assign("payments","innerHTML",$payment_block);
			$objResponse->assign("product_$id", "innerHTML", '');
			$objResponse->assign("checkout_products_howmuch","innerHTML", $_SESSION['cart']->count_contents());
			$objResponse->script("document.getElementById('loader_products').style.display = 'none';
								  document.getElementById('product_$id').style.display = 'none';
								  showFromStart('products');
								  document.getElementById('checkout_hiddens').innerHTML = '$payment_button';
								  document.getElementById('shipping_module_error').innerHTML = '&nbsp;';
								  document.getElementById('payment_module_error').innerHTML = '&nbsp;';
								  if (document.getElementById('btn_shipping_modules').innerHTML == '-') showFromStart('shipping_modules');
								  if (document.getElementById('btn_shipping_address').innerHTML == '-') showFromStart('shipping_address');
								  smodule_length = $shippings_count;
								  ");


			if ($virtual == 1) {
				$objResponse->script("updateBecauseItsVirtual();");
			} else {
				if ($checkout->isFreeShipping($order, $xtPrice)) {
					$objResponse->script("updateBecauseItsFreeShipping();");
				}  else {
					$objResponse->script("updateBecauseItsNotFreeShipping();");
				}
			}
			$objResponse->assign("checkout_total","innerHTML",$checkout->getTotalBlock($order, $order_total_modules, $xtPrice));

		} else {
			$objResponse->assign("product_$id", "innerHTML", CHECKOUT_EMPTY_CART);
			$objResponse->script("document.getElementById('loader_products').style.display = 'none';
								  window.location.href = '".FILENAME_SHOPPING_CART."';
								  showFromStart('products');");
		}
	}
	return $objResponse;
}

function updateAttributes($html_id, $html_aid, $att_string) {
	$objResponse = new xajaxResponse();
	if (empty($_SESSION['customer_id'])) {
		$objResponse->script("window.location.href = '".FILENAME_LOGIN."';");
	} else {
		global $xtPrice;
		global $order;
		global $checkout;
		global $total_weight;
		global $total_count;
		global $shipping_modules;
		global $order_total_modules;
		unset($_SESSION['actual_content']);

		$att_array = explode('|',$att_string);
		$old_att_query = xtc_db_query("SELECT products_options_value_id FROM ".TABLE_CUSTOMERS_BASKET_ATTRIBUTES." WHERE products_options_id = '".$att_array[1]."' AND products_id = '".$att_array[0]."'");
		$old_att_array = xtc_db_fetch_array($old_att_query);
		$old_att = $old_att_array['products_options_value_id'];

		xtc_db_query("UPDATE ".TABLE_CUSTOMERS_BASKET_ATTRIBUTES." SET products_options_value_id = '".$att_array[2]."' WHERE products_options_id = '".$att_array[1]."' AND products_id = '".$att_array[0]."'");

		$_SESSION['cart']->restore_contents();

		if (STOCK_CHECK == 'true' && STOCK_ALLOW_CHECKOUT != 'true') {
			$stock_check = true;
		}
		if (ATTRIBUTE_STOCK_CHECK == 'true' && STOCK_ALLOW_CHECKOUT != 'true') {
			$attribute_stock_check = true;
		}


		$attribute_id_query = xtc_db_query("SELECT products_attributes_id FROM ".TABLE_PRODUCTS_ATTRIBUTES." WHERE options_values_id = '".$att_array[2]."'");
		$attribute_id_arr = xtc_db_fetch_array($attribute_id_query);
		$attribute_id = $attribute_id_arr['products_attributes_id'];


		if (($stock_check ? (xtc_check_stock($att_array[0], $_SESSION['cart']->contents[$att_array[0]]['qty']) != '') : false) || ($attribute_stock_check ? (xtc_check_stock_attributes($attribute_id, $_SESSION['cart']->contents[$att_array[0]]['qty']) != '') : false)) {


			xtc_db_query("UPDATE ".TABLE_CUSTOMERS_BASKET_ATTRIBUTES." SET products_options_value_id = '".$old_att."' WHERE products_options_id = '".$att_array[1]."' AND products_id = '".$att_array[0]."'");
			$_SESSION['cart']->restore_contents();
			$new_value = $att_array[0].'|'.$att_array[1].'|'.$old_att;
			$objResponse->script("document.getElementById('loader_products').style.display = 'none';
								  alert('".utf8_encode(html_entity_decode(CHECKOUT_OUT_OF_STOCK))."');
								  document.getElementById('$html_id').value = '$new_value';
								  document.getElementById('$html_id').disabled = false;
								  ");
		} else {

			$price_new = 0;
			$tax_class_id = $checkout->getTaxID($att_array[0]);

			$price_new = $xtPrice->xtcGetPrice($att_array[0], false, $_SESSION['cart']->contents[$att_array[0]]['qty'], $tax_class_id,'')+$xtPrice->xtcFormat($_SESSION['cart']->attributes_price($att_array[0]), false);
			$price_new *= $_SESSION['cart']->contents[$att_array[0]]['qty'];
			$query = xtc_db_query("SELECT products_options_values_name FROM ".TABLE_PRODUCTS_OPTIONS_VALUES." WHERE language_id = '".$_SESSION['languages_id']."' AND products_options_values_id = '".$att_array[2]."'");
			$row = xtc_db_fetch_array($query);

			$order = new order;

			$total_weight = $_SESSION['cart']->show_weight();
			$total_count = $_SESSION['cart']->count_contents();

			if (!empty($_SESSION['shipping']['id'])) {
				list ($module, $method) = explode('_', $_SESSION['shipping']['id']);
				if (!is_object($shipping_modules)) {
					require (DIR_WS_CLASSES.'shipping.php');
					$shipping_modules = new shipping;
				}
				$quote = $shipping_modules->quote($method, $module);
				$_SESSION['shipping']['cost'] = $quote[0]['methods'][0]['cost'];
			}

			$virtual = $checkout->isVirtual();
			$order = new order;
			$shipping_block = $checkout->getShippingBlock($xtPrice);
			$order = new order;
			$order_total_modules = new order_total;
			$order_total_modules->process();
			$payment_modules = new payment();
			$payment_modules->update_status();

			$payment_button = '';
			$payment_button .= utf8_encode(str_replace("\n","",$payment_modules->process_button(true)));

			global $payment_compatible;
			$payment_compatible = true;
			$payment_block = $checkout->getPaymentBlock($xtPrice, $payment_modules);

			if ($virtual == 1) {
				$objResponse->script("updateBecauseItsVirtual();");
			} else {
				if ($checkout->isFreeShipping($order, $xtPrice)) {
					$objResponse->script("updateBecauseItsFreeShipping();");
				}  else {
					$objResponse->script("updateBecauseItsNotFreeShipping();");
				}
			}
			if ($order->info['total'] <= 0) {
				if (!empty($_SESSION['payment']) && $_SESSION['payment'] != 'no_payment') {
					$_SESSION['old_payment'] = $_SESSION['payment'];
					$_SESSION['payment'] = 'no_payment';
				}
				$order = new order;
				$order_total_modules = new order_total;
				$order_total_modules->process();
				$form_url = $checkout->getFormUrl();

				$objResponse->script("document.getElementById('payment_modules').style.display = 'none';
									  document.getElementById('payment_gccover').style.display = '';
							  		  document.getElementById('checkout').action = '$form_url';
									  if (document.getElementById('btn_payment_modules').innerHTML == '-') { showFromStart('payment_modules') }");

			} else {
				if (!empty($_SESSION['old_payment'])) {
					$_SESSION['payment'] = $_SESSION['old_payment'];
					unset($_SESSION['old_payment']);
					$order = new order;
					$order_total_modules = new order_total;
					$order_total_modules->process();
				}
				$form_url = $checkout->getFormUrl();
				$objResponse->script("document.getElementById('payment_modules').style.display = '';
									  document.getElementById('payment_gccover').style.display = 'none';
							  		  document.getElementById('checkout').action = '$form_url';
									  if (document.getElementById('btn_payment_modules').innerHTML == '-') { showFromStart('payment_modules') }");
			}

			$shippings_count = xtc_count_shipping_modules();
			$objResponse->assign("shippings", "innerHTML", $shipping_block);
			$objResponse->assign("payments","innerHTML",$payment_block);
			$objResponse->assign("attt_$html_aid","innerHTML", htmlentities($row['products_options_values_name']));
			$objResponse->assign("price_".$att_array[0],"innerHTML", $xtPrice->xtcFormat($price_new, true));
			$objResponse->script("document.getElementById('loader_products').style.display = 'none';
								  document.getElementById('atta_$html_aid').style.display = '';
								  document.getElementById('attd_$html_aid').style.display = 'none';
								  showFromStart('products');
								  document.getElementById('checkout_hiddens').innerHTML = '$payment_button';
								  document.getElementById('shipping_module_error').innerHTML = '&nbsp;';
								  document.getElementById('payment_module_error').innerHTML = '&nbsp;';
								  if (document.getElementById('btn_shipping_modules').innerHTML == '-') showFromStart('shipping_modules');
								  smodule_length = $shippings_count;
								  ");
			$objResponse->assign("checkout_total","innerHTML",$checkout->getTotalBlock($order, $order_total_modules, $xtPrice));
		}
	}
	return $objResponse;
}

function updateAddressSelect($which) {
	$objResponse = new xajaxResponse();
	if (empty($_SESSION['customer_id'])) {
		$objResponse->script("window.location.href = '".FILENAME_LOGIN."';");
	} else {
		global $checkout;
		$objResponse->assign("dyn_".$which."_address", "innerHTML", $checkout->getAddresses($which));
		$objResponse->script("document.getElementById('".$which."_address_select').style.display = '';
							  document.getElementById('".$which."_address').style.display = 'none';
							  document.getElementById('".$which."_address_button_edit').style.display = 'none';
							  document.getElementById('".$which."_address_button_save').style.display = '';
							  makeActive(document.getElementById('chkt_".$which."_address'));
							  document.getElementById('loader_".$which."_address').style.display = 'none';
							  showFromStart('".$which."_address');");
	}
	return $objResponse;
}

function updateAddressBySelect($which, $id) {
	$objResponse = new xajaxResponse();
	if (empty($_SESSION['customer_id'])) {
		$objResponse->script("window.location.href = '".FILENAME_LOGIN."';");
	} else {
		global $order;
		global $checkout;
		global $xtPrice;
		global $order_total_modules;

		if ($which == 'shipping') {
			$sess = 'sendto';
		} elseif ($which == 'payment') {
			$sess = 'billto';
		}
		$_SESSION[$sess] = (int)$id;
		if ($which == 'shipping') {
			//unset($_SESSION['payment']);
			//unset($_SESSION['shipping']);

			$xtPrice = new xtcPrice($_SESSION['currency'], $_SESSION['customers_status']['customers_status_id']);
			$order = new order();
			$zone_change = false;
			if ($_SESSION['delivery_zone'] != $order->delivery['country']['iso_code_2']) {
				$zone_change = true;
			}
			$_SESSION['delivery_zone'] = $order->delivery['country']['iso_code_2'];

			if ($checkout->isFreeShipping($order, $xtPrice)) {
				$objResponse->script("updateBecauseItsFreeShipping();");
			}  else {
				$objResponse->script("updateBecauseItsNotFreeShipping();");
			}

			$product_ids = explode(', ',$_SESSION['cart']->get_product_id_list());
			for ($b=0; $b<count($product_ids); $b++) {
				$tax_class_id = $checkout->getTaxID($product_ids[$b]);
				$product_qty = $_SESSION['cart']->contents[$product_ids[$b]]['qty'];
				$product_price = $xtPrice->xtcGetPrice($product_ids[$b], false, $product_qty, $tax_class_id, '')+$xtPrice->xtcFormat($_SESSION['cart']->attributes_price($product_ids[$b]), false);
				$product_price *= $product_qty;
				$objResponse->assign("price_".$product_ids[$b], "innerHTML", $xtPrice->xtcFormat($product_price, true));
			}
		}

		$objResponse->assign($which."_address", "innerHTML", xtc_address_label($_SESSION['customer_id'], $_SESSION[$sess], true, ' ', '<br />'));
		if ($which == 'shipping' && isset ($_SESSION['credit_covers'])) $_SESSION['payment'] = 'no_payment';
		if ($which == 'shipping') {
			$order = new order;
			$shipping_block = $checkout->getShippingBlock($xtPrice);
			$order = new order;
			$order_total_modules = new order_total;
			$order_total_modules->process();
			$payment_modules = new payment();
			$payment_modules->update_status();

			$payment_button = '';
			$payment_button .= utf8_encode(str_replace("\n", "", $payment_modules->process_button(true)));

			$payment_block = $checkout->getPaymentBlock($xtPrice, $payment_modules);
			$form_url = $checkout->getFormUrl();

			$objResponse->assign("shippings", "innerHTML", $shipping_block);
			$objResponse->assign("payments", "innerHTML", $payment_block);
			$objResponse->script("if (document.getElementById('btn_shipping_modules').innerHTML == '-') showFromStart('shipping_modules');");
			$objResponse->script("if (document.getElementById('btn_payment_modules').innerHTML == '-') setTimeout(\"showFromStart('payment_modules')\", 650);
								  document.getElementById('checkout_hiddens').innerHTML = '$payment_button';");
		}

		$objResponse->script("document.getElementById('".$which."_address_select').style.display = 'none';
							  document.getElementById('".$which."_address').style.display = '';
							  document.getElementById('".$which."_address_button_edit').style.display = '';
							  document.getElementById('".$which."_address_button_save').style.display = 'none';
							  document.getElementById('loader_".$which."_address').style.display = 'none';
							  document.getElementById('checkout').action = '$form_url';
							  document.getElementById('shipping_module_error').innerHTML = '&nbsp;';
							  document.getElementById('payment_module_error').innerHTML = '&nbsp;';
							  showFromStart('".$which."_address');");
		if ($which == 'shipping') {
			$objResponse->assign("checkout_total","innerHTML", $checkout->getTotalBlock($order, $order_total_modules, $xtPrice));
		}
	}
	return $objResponse;
}

function updateStates($cid, $which) {
	$objResponse = new xajaxResponse();
	if (empty($_SESSION['customer_id'])) {
		$objResponse->script("window.location.href = '".FILENAME_LOGIN."';");
	} else {
		$zones_array = array ();
		$zones_query = xtc_db_query("select zone_name from ".TABLE_ZONES." where zone_country_id = '".xtc_db_input($cid)."' order by zone_name");
		while ($zones_values = xtc_db_fetch_array($zones_query)) {
			$zones_array[] = array ('id' => $zones_values['zone_name'], 'text' => $zones_values['zone_name']);
		}
		$entry_state = '';
		if (count($zones_array) > 0) {
			$entry_state = xtc_draw_pull_down_menuNote(array ('name' => 'state', 'text' => '&nbsp;'. (xtc_not_null(ENTRY_STATE_TEXT) ? '<span class="inputRequirement">'.ENTRY_STATE_TEXT.'</span>' : '')), $zones_array);
			$state_stat = 1;
		} else {
			$state_stat = 0;
		}
		if ($state_stat == 0) {
			$objResponse->script("for (var e=0; e<document.getElementById('$which').getElementsByTagName('tr').length; e++) {
								  if (document.getElementById('$which').getElementsByTagName('tr')[e].id == 'checkout_states_row') { document.getElementById('$which').getElementsByTagName('tr')[e].style.display = 'none'; break; }
								  }");
		} else {
			$objResponse->script("for (var e=0; e<document.getElementById('$which').getElementsByTagName('tr').length; e++) {
								  if (document.getElementById('$which').getElementsByTagName('tr')[e].id == 'checkout_states_row') { document.getElementById('$which').getElementsByTagName('tr')[e].style.display = ''; break; }
								  }");
		}
		$objResponse->script("document.getElementById('loader_".substr($which, 5)."').style.display = 'none';
							  for (var e=0; e<document.getElementById('$which').getElementsByTagName('span').length; e++) {
							  if (document.getElementById('$which').getElementsByTagName('span')[e].id == 'checkout_states') { document.getElementById('$which').getElementsByTagName('span')[e].innerHTML = '".utf8_encode($entry_state)."'; break; }
							  }");
	}
	return $objResponse;
}

function updateAddress($vars, $which) {
	$objResponse = new xajaxResponse();
	if (empty($_SESSION['customer_id'])) {
		$objResponse->script("window.location.href = '".FILENAME_LOGIN."';");
	} else {
		global $checkout;
		global $xtPrice;
		global $order;
		global $order_total_modules;

		if ($checkout->newAddressPossible()) {
			$vars = $checkout->convertToVars($vars);
			if ($which == 'shipping') {
				$sess = 'sendto';
			} elseif ($which == 'payment') {
				$sess = 'billto';
			}
			require_once (DIR_FS_INC.'xtc_get_country_name.inc.php');
			require_once (DIR_FS_INC.'xtc_get_zone_code.inc.php');

			$process = true;
			$error = false;
			$error_text = '';
			if (ACCOUNT_GENDER == 'true')
				$gender = xtc_db_prepare_input($vars['gender']);
			if (ACCOUNT_COMPANY == 'true')
				$company = xtc_db_prepare_input(utf8_encode($vars['company']));
			$firstname = xtc_db_prepare_input(utf8_encode($vars['firstname']));
			$lastname = xtc_db_prepare_input(utf8_encode($vars['lastname']));
			$street_address = xtc_db_prepare_input(utf8_encode($vars['street_address']));
			if (ACCOUNT_SUBURB == 'true')
				$suburb = xtc_db_prepare_input(utf8_encode($vars['suburb']));
			$postcode = xtc_db_prepare_input($vars['postcode']);
			$city = xtc_db_prepare_input(utf8_encode($vars['city']));
			$country = xtc_db_prepare_input($vars['country']);
			if (ACCOUNT_STATE == 'true') {
				$zone_id = xtc_db_prepare_input($vars['zone_id']);
				$state = xtc_db_prepare_input(utf8_encode($vars['state']));
			}

			if (ACCOUNT_GENDER == 'true') {
				if (($gender != 'm') && ($gender != 'f')) {
					$error = true;

					$error_text .= '- '.ENTRY_GENDER_ERROR.'<br />';
				}
			}

			if (strlen($firstname) < ENTRY_FIRST_NAME_MIN_LENGTH) {
				$error = true;

				$error_text .= '- '.ENTRY_FIRST_NAME_ERROR.'<br />';
			}

			if (strlen($lastname) < ENTRY_LAST_NAME_MIN_LENGTH) {
				$error = true;

				$error_text .= '- '.ENTRY_LAST_NAME_ERROR.'<br />';
			}

			if (strlen($street_address) < ENTRY_STREET_ADDRESS_MIN_LENGTH) {
				$error = true;

				$error_text .= '- '.ENTRY_STREET_ADDRESS_ERROR.'<br />';
			}

			if (strlen($postcode) < ENTRY_POSTCODE_MIN_LENGTH) {
				$error = true;

				$error_text .= '- '.ENTRY_POST_CODE_ERROR.'<br />';
			}

			if (strlen($city) < ENTRY_CITY_MIN_LENGTH) {
				$error = true;

				$error_text .= '- '.ENTRY_CITY_ERROR.'<br />';
			}

			if (ACCOUNT_STATE == 'true') {
				$zone_id = 0;
				$check_query = xtc_db_query("select count(*) as total from ".TABLE_ZONES." where zone_country_id = '".(int) $country."'");
				$check = xtc_db_fetch_array($check_query);
				$entry_state_has_zones = ($check['total'] > 0);
				if ($entry_state_has_zones == true) {
					$zone_query = xtc_db_query("select distinct zone_id from ".TABLE_ZONES." where zone_country_id = '".(int) $country."' and (zone_name like '".xtc_db_input($state)."%' or zone_code like '%".xtc_db_input($state)."%')");
					if (xtc_db_num_rows($zone_query) > 1) {
						$zone_query = xtc_db_query("select distinct zone_id from ".TABLE_ZONES." where zone_country_id = '".(int) $country."' and zone_name = '".xtc_db_input($state)."'");
					}
					if (xtc_db_num_rows($zone_query) >= 1) {
						$zone = xtc_db_fetch_array($zone_query);
						$zone_id = $zone['zone_id'];
					} else {
						$error = true;

						$error_text .= '- '.ENTRY_STATE_ERROR_SELECT.'<br />';
					}
				} else {
					if (strlen($state) < ENTRY_STATE_MIN_LENGTH && $zone_id > 0) {
						$error = true;

						$error_text .= '- '.ENTRY_STATE_ERROR.'<br />';
					}
				}
			}

			if ((is_numeric($country) == false) || ($country < 1)) {
				$error = true;

				$error_text .= '- '.ENTRY_COUNTRY_ERROR.'<br />';
			}

			if ($error == false) {
				$sql_data_array = array ('customers_id' => $_SESSION['customer_id'], 'entry_firstname' => $firstname, 'entry_lastname' => $lastname, 'entry_street_address' => $street_address, 'entry_postcode' => $postcode, 'entry_city' => $city, 'entry_country_id' => $country);

				if (ACCOUNT_GENDER == 'true')
					$sql_data_array['entry_gender'] = $gender;
				if (ACCOUNT_COMPANY == 'true')
					$sql_data_array['entry_company'] = $company;
				if (ACCOUNT_SUBURB == 'true')
					$sql_data_array['entry_suburb'] = $suburb;
				if (ACCOUNT_STATE == 'true') {
					if ($zone_id > 0) {
						$sql_data_array['entry_zone_id'] = $zone_id;
						$sql_data_array['entry_state'] = '';
					} else {
						$sql_data_array['entry_zone_id'] = '0';
						$sql_data_array['entry_state'] = $state;
					}
				}

				xtc_db_perform(TABLE_ADDRESS_BOOK, $sql_data_array);

				$_SESSION[$sess] = xtc_db_insert_id();

				if ($which == 'shipping') {
					$xtPrice = new xtcPrice($_SESSION['currency'], $_SESSION['customers_status']['customers_status_id']);
					$order = new order();
					$zone_change = false;
					if ($_SESSION['delivery_zone'] != $order->delivery['country']['iso_code_2']) {
						$zone_change = true;
					}
					$_SESSION['delivery_zone'] = $order->delivery['country']['iso_code_2'];

					if ($checkout->isFreeShipping($order, $xtPrice)) {
						$objResponse->script("updateBecauseItsFreeShipping();");
					}  else {
						$objResponse->script("updateBecauseItsNotFreeShipping();");
					}

					$product_ids = explode(', ',$_SESSION['cart']->get_product_id_list());
					for ($b=0; $b<count($product_ids); $b++) {
						$tax_class_id = $checkout->getTaxID($product_ids[$b]);
						$product_qty = $_SESSION['cart']->contents[$product_ids[$b]]['qty'];
						$product_price = $xtPrice->xtcGetPrice($product_ids[$b], $format=false, $product_qty, $tax_class_id, '')+$xtPrice->xtcFormat($_SESSION['cart']->attributes_price($product_ids[$b]), false);
						$product_price *= $product_qty;
						$objResponse->assign("price_".$product_ids[$b], "innerHTML", $xtPrice->xtcFormat($product_price, true));
					}
				}

				$objResponse->assign($which."_address_error","innerHTML","");
				$objResponse->assign($which."_address", "innerHTML", xtc_address_label($_SESSION['customer_id'], $_SESSION[$sess], true, ' ', '<br />'));
				if ($which == 'shipping' && isset ($_SESSION['credit_covers'])) $_SESSION['payment'] = 'no_payment';
				if ($which == 'shipping') {
					$order = new order;
					$shipping_block = $checkout->getShippingBlock($xtPrice);
					$order = new order;
					$order_total_modules = new order_total;
					$order_total_modules->process();
					$payment_modules = new payment();
					$payment_modules->update_status();

					$payment_button = '';
					$payment_button .= utf8_encode(str_replace("\n","",$payment_modules->process_button(true)));
					$payment_block = $checkout->getPaymentBlock($xtPrice, $payment_modules);
					$form_url = $checkout->getFormUrl();
					$objResponse->assign("shippings", "innerHTML", $shipping_block);
					$objResponse->assign("payments", "innerHTML", $payment_block);
					$objResponse->script("if (document.getElementById('btn_shipping_modules').innerHTML == '-') showFromStart('shipping_modules');");
					$objResponse->script("if (document.getElementById('btn_payment_modules').innerHTML == '-') setTimeout(\"showFromStart('payment_modules')\", 500);
										  document.getElementById('checkout_hiddens').innerHTML = '$payment_button';");
				}
				$objResponse->script("document.getElementById('".$which."_address_select').style.display = 'none';
									  document.getElementById('".$which."_address').style.display = '';
									  document.getElementById('".$which."_address_button_edit').style.display = '';
									  document.getElementById('".$which."_address_button_save').style.display = 'none';
									  document.getElementById('loader_".$which."_address').style.display = 'none';
									  document.getElementById('shipping_module_error').innerHTML = '&nbsp;';
									  document.getElementById('payment_module_error').innerHTML = '&nbsp;';
									  document.getElementById('checkout').action = '$form_url';
									  showFromStart('".$which."_address');");
				if ($which == 'shipping') {
					$objResponse->assign("checkout_total","innerHTML",$checkout->getTotalBlock($order, $order_total_modules, $xtPrice));
				}


			} else {
				$objResponse->assign($which."_address_error","innerHTML",$error_text);
				$objResponse->script("makeActive(document.getElementById('chkt_".$which."_address'));
									  document.getElementById('loader_".$which."_address').style.display = 'none';
									  showFromStart('".$which."_address');");
			}
		} else {
			$error_text = '- '.CHECKOUT_NOMORE_ADDRESSES;
			$objResponse->assign($which."_address_error","innerHTML",$error_text);
			$objResponse->script("document.getElementById('loader_".$which."_address').style.display = 'none';
								  showFromStart('".$which."_address');");
		}
	}
	return $objResponse;
}

require_once(DIR_WS_INCLUDES.'xajax/xajax_core/xajax.inc.php');

$xajax = new xajax();
$xajax->setRequestURI(xtc_href_link(FILENAME_CHECKOUT, '', 'SSL'));
$xajax->registerFunction("updateProducts");
$xajax->registerFunction("updateAttributes");
$xajax->registerFunction("removeProduct");
$xajax->registerFunction("updateAddressSelect");
$xajax->registerFunction("updateAddressBySelect");
$xajax->registerFunction("updateStates");
$xajax->registerFunction("updateAddress");
$xajax->registerFunction("useGV");
$xajax->registerFunction("updatePaymentModule");
$xajax->registerFunction("updateShippingModule");
$xajax->registerFunction("checkout_check");

$xajax->processRequest();
?>